unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, WPStatus, PrinPr, Wpstat2, WPTbar, WPDefs, WPPrTab1;

type                 
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    WPToolBar1: TWPToolBar;
    WPAltStatusBar1: TWPAltStatusBar;
    Preview: TButton;
    Timer1: TTimer;
    CreateTable: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure WPToolBar1IconSelection(Sender: TObject; var Typ: TWpSelNr;
      const str: string; const group, num, index: Integer);
    procedure PreviewClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CreateTableClick(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
    procedure ShowHint(Sender: TObject);
    procedure EditStateEvent(Sender: TObject;
            selection_marked, clipboard_not_empty: Boolean);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}


uses ChildWin;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
  WPToolBar1.AddControl(CreateTable);
  WPToolBar1.AddControl(Preview);
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  WPAltStatusBar1.SetString(stStatus,Application.Hint); {NEW}
  Timer1.Enabled := TRUE;
end;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  GlobalToolBar := WPToolBar1;
  GlobalStatusBar := WPAltStatusBar1;
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  Child.Memo.EditStateEvent:=EditStateEvent; { NEW }
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpenItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin  CreateMDIChild(OpenDialog.FileName);
         (ActiveMDIChild as TMDIChild).Memo.Clear;
         (ActiveMDIChild as TMDIChild).Memo.LoadFromFile(OpenDialog.FileName); {NEW}
         (ActiveMDIChild as TMDIChild).Memo.LastFileName := OpenDialog.FileName;
  end;
end;

procedure TMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMainForm.FileSaveItemClick(Sender: TObject);
begin
  { save current file (ActiveMDIChild points to the window) }
  (ActiveMDIChild as TMDIChild).Memo.Save;  {NEW}
end;

procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
begin
  { save current file under new name }
  (ActiveMDIChild as TMDIChild).Memo.SaveAs; {NEW}
  (ActiveMDIChild as TMDIChild).Caption :=
      (ActiveMDIChild as TMDIChild).Memo.LastFileName;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
begin
  {cut selection to clipboard}
  (ActiveMDIChild as TMDIChild).Memo.CutToClipboard; {NEW}
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
begin
  {copy selection to clipboard}
  (ActiveMDIChild as TMDIChild).Memo.CopyToClipboard; {NEW}
end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
  {paste from clipboard}
   (ActiveMDIChild as TMDIChild).Memo.PasteFromClipboard; {NEW}
end;

procedure EditStateEvent(Sender: TObject;    { NEW }
            selection_marked, clipboard_not_empty: Boolean);
begin

end;


procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;


procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  PasteItem.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.WPToolBar1IconSelection(Sender: TObject; var Typ: TWpSelNr;
  const str: string; const group, num, index: Integer);
begin
   if Typ<>wptNone then
   begin
     if typ=wptIconSel then
     begin
     if group=WPI_GR_DISK then case num of
       WPI_CO_OPEN : begin if OpenDialog.Execute then
                           begin CreateMDIChild(OpenDialog.FileName);
                              if ActiveMDIChild <> nil then
                              begin
                                (ActiveMDIChild as TMDIChild).Memo.Clear;
                                (ActiveMDIChild as TMDIChild).
                                      Memo.LoadFromFile(OpenDialog.FileName);
                              end;
                           end;
                           if WPToolBar1<>nil then
                              WPToolBar1.DeselectIcon(0,WPI_GR_DISK,WPI_CO_OPEN);
                           Typ:=wptNone;
                     end;
       WPI_CO_ClOSE : begin
                            if ActiveMDIChild <> nil then
                            begin
                                (ActiveMDIChild as TMDIChild).Memo.Save;
                                ActiveMDIChild.Close;
                            end;
                            if WPToolBar1<>nil then
                              WPToolBar1.DeselectIcon(0,WPI_GR_DISK,WPI_CO_CLOSE);
                            Typ:=wptNone;
                     end;
       WPI_CO_EXIT : Close;
       end;  end;
   end;
end;

procedure TMainForm.PreviewClick(Sender: TObject);
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  with (ActiveMDIChild as TMDIChild) do
  try
      WPRuler1.Visible := FALSE;
      PrintPreview := TPrintPreview.Create(Self);
      PrintPreview.WordProcessor := Memo;
      PrintPreview.ShowModal;
  finally
      WPRuler1.Visible := TRUE;
      PrintPreview.Free;
  end;
end;

{ NEW }
procedure TMainForm.EditStateEvent(Sender: TObject;
  selection_marked, clipboard_not_empty: Boolean);
begin
  CutItem.Enabled := selection_marked;
  CopyItem.Enabled := selection_marked;
  PasteItem.Enabled := clipboard_not_empty;
end;


procedure TMainForm.Timer1Timer(Sender: TObject);
begin
   WPAltStatusBar1.SetString(stStatus,' ');
   Timer1.Enabled := FALSE;
end;

{ Show Form to create a table
  unit : WPPrTab1}
procedure TMainForm.CreateTableClick(Sender: TObject);
var
  WPTableSelect: TWPTableSelect;
  p : TPoint;
begin
  if (ActiveMDIChild <> nil) and (ActiveMDIChild is TMDIChild) then
  with (ActiveMDIChild as TMDIChild) do
  try
     WPTableSelect:= TWPTableSelect.Create(Self);
     p.x := 0;
     p.y := 0;
     p := CreateTable.ClientToScreen(p);
     WPTableSelect.Left := p.x;
     WPTableSelect.Top  := p.y + CreateTable.Height;
     if WPTableSelect.ShowModal = IDOK then
     begin
       Memo.CreateTable(  WPTableSelect.col,
                                 WPTableSelect.row,nil,
                                 WPTableSelect.ShowBord.Down );
     end;
  finally
     WPTableSelect.Free;
  end;
end;

end.
